
Declare Sub __Zoey_Globals_Configure ( __Alisha_ As __Alisha_Globals_Type )

Declare Sub __Zoey_Globals_Macros ( __Alisha_ As __Alisha_Globals_Type )

Declare Sub __Zoey_Globals_To_KVP ( __Alisha_ As __Alisha_Globals_Type )

Sub __Zoey_Globals_Configure ( __Alisha_ As __Alisha_Globals_Type )

	__Zoey_Globals_Macros ( __Alisha_ )

	With __Alisha_
		
		._Author = __Author
	
		'._Version_Raw = ._Version
		'._Version_Verbose = ._Version
		'._Version_Pretty = ._Version_Pretty
		._Title = ._Author & "'s " & ._Project & " (" & ._Version_Pretty & ")"
	
	End With

End Sub

Sub __Zoey_Globals_Macros ( __Alisha_ As __Alisha_Globals_Type )

	Dim	As Long Index = 0
	
	With __Alisha_
		
		._Path = __PATH__
		
		For Index = Len ( ._Path ) To 1 Step -1
			Select Case Mid ( ._Path, Index, 1 )
			Case "/"
				Mid ( ._Path, Index, 1 ) = "\"
			End Select
		Next Index
		
		._Root = ._Path
		
		._Project = __FILE__

		For Index = Len ( ._Project ) To 1 Step -1
			Select Case Mid ( ._Project, Index, 1 )
			Case "/"
				Mid ( ._Project, Index, 1 ) = "\"
			End Select
		Next Index
		
		Index = Instr ( ._Project, "\" )
		Do While Index > 0
			._Project = Mid ( ._Project, Index + 1 )
			Index = Instr( ._Project, "\" )
		Loop		

		Index = InstrRev ( ._Project, "." )
		Do While Index > 0
			._Project = Left ( ._Project, Index - 1 )
			Index = Instr( ._Project, "." )
		Loop		


		Do While Left ( ._Project, 1 ) = SP
			._Project = Mid ( ._Project, 2 )
		Loop
		
		Do While Right ( ._Project, 1 ) = SP
			._Project = Left ( ._Project, Len ( ._Project ) - 1 )
		Loop
		
		._Version = ._Path
		
		For Index As Long = Len ( ._Version ) To 1 Step -1
			Select Case Mid ( ._Version, Index, 1 )
			Case ")"
				._Version = Left ( ._Version, Index - 1 )
			End Select
		Next Index
		
		For Index As Long = Len ( ._Version ) To 1 Step -1
			Select Case Mid ( ._Version, Index, 1 )
			Case "("
				._Version = Mid ( ._Version, Index + 1 )
			End Select
		Next Index
		
		Do While Right ( ._Version, 1 ) = " "
			._Version = Left ( ._Version, Len ( ._Version ) - 1 )
		Loop
		
		Do While Left ( ._Version, 1 ) = " "
			._Version = Mid ( ._Version, 2 )
		Loop
		
		._Version_Pretty = ._Version
		
		For Index As Long = Len ( ._Version_Pretty ) To 1 Step -1
			Select Case Mid ( ._Version_Pretty, Index, 1 )
			Case "-", "."
				Mid ( ._Version_Pretty, Index, 1 ) = "."
			End Select
		Next Index
			
		Do While Right ( ._Root, 1 ) <> "\"
			._Root = Left ( ._Root, Len ( ._Root ) - 1 )
		Loop
	
	End With
	
End Sub

Sub __Zoey_Globals_To_KVP ( __Alisha_ As __Alisha_Globals_Type )
	
	With __Alisha_
		
		SimpleSleep ( "Sub __Zoey_Globals_To_KVP ( )" )

		ReDim As KVP_Database DB ( Any )

		SimpleSleep ( "Erase DB" )	
		KVP_Erase ( DB ( ) )			

		SimpleSleep ( "Bubble_Sort DB" )	
		KVP_Bubble_Sort ( DB ( ) )

		'SimpleSleep ( "--- Adding brick ---" )
		'._CI = "@Exit" : KVP_Database_Set ( DB ( ), "brick", "inbad" )
			
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "_Path", ._Path )

		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "_Root", ._Root )
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "_File", ._File )
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "_Ext", ._Ext )
		
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "_Project", ._Project )
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "_Author", ._Author )
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "_Version", ._Version )
		
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "_Version_Raw", ._Version_Raw )
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "_Version_Verbose", ._Version_Verbose )
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "_Version_Pretty", ._Version_Pretty )
		
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "Prompt::_Buffer::Width", ._Buffer -> Width )
		
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "Prompt::_Buffer::Height", ._Buffer -> Height )
		
		'._CI = "@Exit" : KVP_Database_Set ( DB ( ), "_Buffer", ._Buffer )
		
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "Prompt::_Col", ._Col )
		
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "Prompt::_Row", ._Row )
		
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "Prompt::_C", ._C )
		
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "Prompt::_CI", ._CI )
		
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "Prompt::_Msg", ._Msg )
		
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "Prompt::_VGA_FG", ._VGA_FG )
		
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "Prompt::_VGA_BG", ._VGA_BG )
		
		._CI = "@Exit" : KVP_Database_Set ( DB ( ), "Prompt::_VGA_Mask", ._VGA_Mask )
		
		._CI = "@Exit" : SimpleSleep ( "KVP_Database_Save DB ( )" )
		
		KVP_Database_Save ( DB ( ), ".\Vars.KVP" )
		
		SimpleSleep ( "Erase DB" )	
		KVP_Erase ( DB ( ) )
		
	End With
	
End Sub 

/'
__Zoey_Globals_To_KVP __Alisha_

With __Alisha_
			
	._Buffer = ImageCreate ( 320, 240, RGBA ( 0, 0, 0, 0 ), 32 )
	
	._Col = 1 : ._Row = 1
	._C = "" : ._CI = ""
	
	._Msg = "Hello, World!" : ._Prompt = ""
	._VGA_FG = VGA_Lookup2 ( 15, ._VGA_Table ( ) )
	._VGA_BG = VGA_Lookup2 ( 0, ._VGA_Table ( ) )
	
	SimplePrompt ( __Alisha_ )
	
	__Zoey_Globals_To_KVP __Alisha_

	._Col = 1 : ._Row = 1
	._C = "" : ._CI = ""
	
	._Msg = "What is your desire?" : ._Prompt = ""
	._VGA_FG = VGA_Lookup2 ( 14, ._VGA_Table ( ) )
	._VGA_BG = VGA_Lookup2 ( 0, ._VGA_Table ( ) )

	SimplePrompt ( __Alisha_ )
	
	__Zoey_Globals_To_KVP __Alisha_
	
End With

__Zoey_Globals_To_KVP __Alisha_
'/
